#pragma once

#include "csfunified/services/mock/MockConfigService.h"
#include "csfunified/services/mock/MockConfigValue.h"

#include "jcfcoreutils/StringUtils.h"

#include <string>
#include <map>

namespace CSFUnified
{
    DECLARE_PTR(ConfigValue);
    DECLARE_PTR(ConfigService);
}

namespace UnitTestUtils
{
    DECLARE_PTR(ConfigValue);
    DECLARE_PTR(ConfigService);

    class ConfigValue : public CSFUnified::Mock::MockConfigValue
    {
    public:
        std::wstring getValue()
        {
            return value;
        }

		bool getisDefined()
		{
			return true;
		}

        std::wstring value;
    };

    class ConfigService : public CSFUnified::Mock::MockConfigService
    {
    public:
        typedef std::map<std::wstring, CSFUnified::ConfigValuePtr> ConfigMap;

        CSFUnified::ConfigValuePtr getConfig(std::wstring key)
        {
            ConfigMap::iterator it = configMap.find(key);

            if(it == configMap.end())
            {
                ConfigValuePtr emptyValue( new ConfigValue() );

                return emptyValue;
            }

            return it->second;
        }

        void addConfig(const std::wstring& key, const std::wstring& value)
        {
            ConfigValuePtr configValue(new ConfigValue());
            configValue->value = value;

            configMap[key] = configValue;
        }

        void addConfig(const std::string& key, const std::string& value)
        {
            addConfig(JCFCoreUtils::toWideString(key), JCFCoreUtils::toWideString(value));
        }

        ConfigMap configMap;
    };
}


